local P1, P2, P1Score, P2Score
local difficulty, sTable
local songName= GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song

--[[

	Some of the code below here is part of the "Preliminary Check"
	We want to just check on a couple things to ensure a safe flight

	1. Version Warning - Stepmania Versions above 5.1 seem to interpet the mods differently 
	2. Edit Chart - If the player is in Edit Mode or is on the Edit Chart, the mods do not play
	3. Mixmatch Choices - If one player is on Edit and the other is not, then both get set to Edit
		This is to ensure that no one is able to get a score on the modded charts by playing/reading an
		unmodded chart

]]--

local version = tonumber(string.match(ProductID(),'%d+%.?%d*$')) or 5.0;
if version > 5.1 then
	SCREENMAN:SystemMessage('Sorry, this song was made for SM 5.1');
end

local WideScale = function(AR4_3, AR16_9)
	-- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
	local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
	return scale( w, 640, 854, AR4_3, AR16_9 )
 end

local function isEditMode()
	local screen = SCREENMAN:GetTopScreen()
	if not screen then
	   return nil
	end
	local screen = SCREENMAN:GetTopScreen()	
	return (THEME:GetMetric(screen:GetName(), "Class") == "ScreenEdit")
end

local SlightFade = function(alpha)
	for player in ivalues(GAMESTATE:GetHumanPlayers()) do
	   
	   -- Get the player ActorFrame on ScreenGameplay.
	   -- It's a direct child of the screen and named "PlayerP1" for P1
	   -- and "PlayerP2" for P2.  This is currently hardcoded in the SM5 engine.
	   --
	   -- note: ScreenEdit does not name its notefield actor and I don't 
	   --       know how to get a reference to it from Lua.
	   local name = ("Player%s"):format( ToEnumShortString(player) )
	   
	   -- get a reference to the player ActorFrame
	   local player_af = SCREENMAN:GetTopScreen():GetChild( name )
	   
	   -- if the player ActorFrame was found (it won't be in Edit Mode)
	   if player_af then
		  -- Get specificially the NoteField out of the player ActorFrame.
		  -- It is a named child ("NoteField"), hardcoded in the SM5 engine.
		  local notefield = player_af:GetChild("NoteField")
		  
		  -- if the notefield was found (it should be, but hey)
		  if notefield then
			 
			 -- for each column in the NoteField
			 -- there are 4 columns in dance single, 8 in dance double, 5 in pump single, etc.
			 for i, column in ipairs(notefield:get_column_actors()) do
				column:diffusealpha(alpha)
			 end
		  end
	   end
	end
 end

 local function Handler_mod_internal(str, pn) -- Applies Players options to not be disabled-
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ' + 0.5, ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function Handler_mod(str) -- Looks for many players are on the screen 
	if (isEditMode()) then return end
	for i=1,2 do
		Handler_mod_internal(str + 0.5, 'PlayerNumber_P' .. i)
	end
end

local function Handler_init() -- Useful for command shorcuts

	if SCREENMAN:GetTopScreen():GetChild('PlayerP1') and not isEditMode() then
		P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
		--P1:visible(false)
	end
	if SCREENMAN:GetTopScreen():GetChild('PlayerP2') and not isEditMode() then
		P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
	--	P2:visible(false)
	end
	if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score') and not isEditMode() then
		P1Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score')
	end
	if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score')and not isEditMode() then
		P2Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score')
	end


	fgcurcommand = 0;
	wndr_skewx=0.3;
	checked = false;
	--lua course :D	/ timed mod management	
	curmod = 1;		
	--{beat,'mod'},
	mods = {
		{128,'*0.25 10% Beat'},
		{191,'*0.25 50% Beat'},
		{256,'*1 no Beat'},
		{268,'1 30% Beat'},
		{310,'*0.5 50% Beat'},


	}
	--SCREAMING GUMBALL / timed message broadcaster
	curmessage = 1;
	--{beat,message,ignoreIfAhead}
	messages = {
		{12, 'FlyBy'},
		{113, 'PickUpItems'},
		{124, 'Rock'},
		{125, 'Ahh'},
		{126, 'Way'},
		{127.5,'Turn'},
		{132-0.075, 'SwitchOn'},
		{148-0.075, 'SwitchOff'},
		{164-0.075, 'SwitchOn'},
		{180-0.075, 'SwitchOff'},
		--{195, 'Recolor', {duration=20}},
		{258-0.12, 'SwitchOn'},
		{265.5, 'SwitchOff'},
		{280-0.075, 'SwitchOn'},
		{296-0.075, 'SwitchOff'},
		--{308, 'Recolor', 20},
		{308, 'SwitchMalfunction'},

		{311, 'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{312.5, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},
		{314, 'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{315.5, 'SwitchColor', {color1= color("#ACF536"), color2=color("#5E7F1E")}},
		{317, 'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{318.5, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},
		{320, 'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{321.5, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},

		{327.5, 'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{329, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},
		{330.5, 'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{332, 'SwitchColor', {color1= color("#ACF536"), color2=color("#5E7F1E")}},
		{333.5, 'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{335, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},
		{336.5, 'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{338, 'SwitchColor', {color1= color("#ACF536"), color2=color("#5E7F1E")}},
		
		{343, 	'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{344.5, 'SwitchColor', {color1= color("#ACF536"), color2=color("#5E7F1E")}},
		{346, 	'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{347.5, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},
		{349, 	'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{351, 	'SwitchColor', {color1= color("#ACF536"), color2=color("#5E7F1E")}},
		{352.5, 	'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{354, 	'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		
		{359.5, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},
		{361, 'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{362.5, 'SwitchColor', {color1= color("#ACF536"), color2=color("#5E7F1E")}},
		{364, 'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{365.5, 'SwitchColor', {color1= color("#FFD400"), color2=color("#7F5A1E")}},
		{367, 'SwitchColor', {color1= color("#F535AA"), color2=color("#7F1E5A")}},
		{368.5, 'SwitchColor', {color1= color("#ACF536"), color2=color("#5E7F1E")}},
		{370, 'SwitchColor', {color1= color("#36ACF5"), color2=color("#1E5A7F")}},
		{380-0.075, 'SwitchGone'}
    }
	
end

local function Handler_update() -- Updates the command to look for the players at the start of the song.

	if GAMESTATE:GetSongBeat()>=0 and not checked then
		
		screen = SCREENMAN:GetTopScreen()
		
		checked = true;
		
	end

	local beat = GAMESTATE:GetSongBeat()

	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		Handler_mod(total_mod_str)
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		add_mod(mods[curmod][2])
		curmod = curmod+1
	end

	execute_mods()
	
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][3] then
			MESSAGEMAN:Broadcast(messages[curmessage][2], messages[curmessage][3])
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2])
			curmessage = curmessage+1;
		end
	end
end
local last_score_x = 0
local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()
return Def.ActorFrame{

	OnCommand= function(self)
			Handler_init()
			self:SetUpdateFunction(Handler_update)
			local screen = SCREENMAN:GetTopScreen()
		end,
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
	-- Def.Quad{
	-- 	OnCommand=function(self)
	-- 		-- if (isEditMode()) then
	-- 		-- 	self:visible(false)
	-- 		-- end
	-- 		self:FullScreen():Center()
	-- 		self:blend("BlendMode_InvertDest")
	-- 	end,
	-- },
	Def.Quad{
		OnCommand=function(self)
			self:FullScreen():Center():diffusealpha(0)
		end,
        SwitchOffMessageCommand=function(self)
            -- -- Diffuse each column actor
            -- for i,column in ipairs(GetPlayerAF(i):GetChild('NoteField'):get_column_actors()) do
            --     column:diffuse(0,0,0,1)
            -- end
        end,
	},
}